library ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.numeric_std.ALL; 

entity demux_sync is
       port(
	     
             clk: in std_logic;
	     input_data: in std_logic;   
             output_data: out std_logic_vector(3 downto 0));
end entity demux_sync;

architecture arch of demux_sync is
        component demux is 
	port( 
              
	      clk: in std_logic;
	      input_data: in std_logic;  
	      output_data: out std_logic_vector(3 downto 0));
                    
	end component demux;


signal demux_data:std_logic_vector(3 downto 0):="0000";
signal clk_outQ:std_logic:='0';
signal a: natural range 0 to 3 :=0;
	




begin

        demux_sync_component:
	component demux
	port map( 
	         
                  clk=>clk,
                  input_data=>input_data,
                  output_data=>demux_data);





p0: process(clk)  
       begin
 	    if(falling_edge(clk)) then
	     
	         if a =3 then
                    a <=0;
                 else
                    a <=a+ 1;
                 end if;
	      
	    end if;
	 		      
end process p0;





p3: process(a , clk, input_data)
begin
 	if(rising_edge(clk)) then
            if a = 0 then
		output_data <= demux_data; 
            end if;
end if;
		
          
end process p3;
end arch;
